#ifndef SPI_H_
#define SPI_H_
#include <avr/io.h>

//Initialize (hardware) SPI in master mode
void spi_init_master (void);

//Send one byte of data and receive one byte of data via (hardware) SPI
uint8_t spi_tranceiver (uint8_t data);

//Initialize (software) SPI in master mode
void softspi_init_master(void);

//Toggle clock/MOSI high or low (these can be made 'inline' void for more efficiency)
void softspi_clk_low(void);
void softspi_clk_high(void);
void softspi_MOSI_low(void);
void softspi_MOSI_high(void);

//Implements (software) SPI in mode 00
uint8_t softspi_tranceiver_00(uint8_t byte);
//Implements (software) SPI in mode 11
uint8_t softspi_tranceiver_11(uint8_t byte);


#endif /* SPI_H_ */